function crosscorrelation(xt,yt)
%Custom-built function that creates the crosscorelation plot for 2 signals.
%A maximal lag of +-20 is assumed.
%
%Inputs:
%   x: signal 1
%   y: signal 2
%
%Copyright 2014: Yuri Shardt
%Distributed as part of the book Statistics for Chemical and Process
%Engineers: A Modern Approach, published by Springer Verlag.

%Checking the data
q1=size(xt);
N1=length(xt);
q2=size(yt);
N2=length(yt);
lag=20;
if (N1~=N2)
    error('Please make sure that both signals have the same length');
end
if (N1<2*lag || N2<2*lag)
    error('Please make sure that the size of yt and zt are at least 40 samples.');
end
if (N1==q1(1) && q1(2)~=1) || (N1==q1(2) && q1(1)~=1) || (N2==q2(1) && q2(2)~=1) || (N2==q2(2) && q2(1)~=1)
    error('Please make sure that both yt and zt is either a row or column vector.');
end
x=detrend(xt,0);
y=detrend(yt,0);

%Obtain the crosscorrelation values
q=xcorr(y,x);
count=N1;
N=N1;
%Creating the plot
plot([-lag:lag],q(count-lag:count+lag)/N1/std(x)/std(y),'ok')
grid on
hold on;plot([-lag,lag],tinv(0.975,N)*[1,1]/sqrt(N),'--k','linewidth',2)
plot([-lag,lag],-tinv(0.975,N)*[1,1]/sqrt(N),'--k','linewidth',2)
plot([-lag,lag],[0,0],'-k')
xlabel(['Lag (samples)'],'interpreter','latex'),ylabel('Crosscorrelation, $\rho_{XY}$','interpreter','latex')

end